$(document).ready(function () {
  // Плавный скролл по якорям
  $('a[href^="#"]').on('click', function (event) {
    event.preventDefault();

    var sc = $(this).attr("href"),
        dn = $(sc).offset().top;

    $('html, body').animate({
      scrollTop: dn
    }, 1000);
  });


  // ===== Колесо + модалка + куки на 24 часа =====
  var wheel        = $("#wheel");
  var spinButton   = $("#spin-button");
  var spinDuration = 9000;          // 9 секунд
  var modal        = $(".modal");
  var DAY_MS       = 24 * 60 * 60 * 1000;

  var TIME_COOKIE  = "wheelSpinTime";
  var PRIZE_COOKIE = "wheelPrize";

  // span внутри текста модалки
  var prizeSpan = $(".modal_rect_up_tittle span");

  // 4 варианта углов
  var spinAngles = [1080, 990, 900, 810];

  // маппинг: угол -> приз
  var angleToPrize = {
    1080: "5000 taškų!",
    990 : "3000 taškų!",
    900 : "4000 taškų!",
    810 : "2000 taškų!"
  };

  // --- функции работы с куками ---
  function setCookie(name, value, maxAgeSeconds) {
    document.cookie = name + "=" + encodeURIComponent(value)
      + "; max-age=" + maxAgeSeconds
      + "; path=/";
  }

  function getCookie(name) {
    var matches = document.cookie.match(
      new RegExp(
        "(?:^|; )" +
        name.replace(/([$?*|{}\(\)\[\]\\\/\+^])/g, "\\$1") +
        "=([^;]*)"
      )
    );
    return matches ? decodeURIComponent(matches[1]) : null;
  }

  function deleteCookie(name) {
    document.cookie = name + "=; max-age=0; path=/";
  }

  // --- при загрузке страницы проверяем, был ли спин за 24 часа ---
  var spinTimeCookie = getCookie(TIME_COOKIE);
  var canSpin = true;

  if (spinTimeCookie) {
    var lastSpin = parseInt(spinTimeCookie, 10);

    if (!isNaN(lastSpin)) {
      var diff = Date.now() - lastSpin;

      if (diff < DAY_MS) {
        // прошло меньше 24 часов – запретить новый спин и сразу показать модалку
        canSpin = false;

        // подставляем сохранённый приз, если есть
        var savedPrize = getCookie(PRIZE_COOKIE);
        if (savedPrize) {
          prizeSpan.text(savedPrize);
        }

        modal.addClass("modal_active");
      } else {
        // прошло больше суток – чистим куки, можно крутить снова
        deleteCookie(TIME_COOKIE);
        deleteCookie(PRIZE_COOKIE);
      }
    } else {
      // если кука битая – чистим
      deleteCookie(TIME_COOKIE);
      deleteCookie(PRIZE_COOKIE);
    }
  }

  // --- обработчик клика по кнопке спина ---
  if (canSpin) {
    spinButton.on("click", function (e) {
      e.preventDefault();

      // выбираем случайный угол из 4 вариантов
      var randomIndex = Math.floor(Math.random() * spinAngles.length);
      var targetAngle = spinAngles[randomIndex];

      // находим соответствующий приз
      var prize = angleToPrize[targetAngle] || "0";

      // сразу записываем приз в span (чтобы к моменту модалки он уже был)
      prizeSpan.text(prize);

      // запускаем анимацию колеса
      wheel.css("transition", "transform " + spinDuration + "ms ease-in-out");
      wheel.css("transform", "rotate(" + targetAngle + "deg)");

      // после окончания анимации ОСТАВЛЯЕМ колесо в этом положении
      setTimeout(function () {
        wheel.css("transition", "none");
        wheel.css("transform", "rotate(" + targetAngle + "deg)");
      }, spinDuration);

      // сохраняем факт спина и приз на 24 часа
      setCookie(TIME_COOKIE, Date.now(), 24 * 60 * 60);
      setCookie(PRIZE_COOKIE, prize,       24 * 60 * 60);

      // показываем модалку через 10 секунд
      setTimeout(function () {
        modal.addClass("modal_active");
      }, 10000);
    });
  } else {
    // опционально: визуально отключить кнопку
    // spinButton.prop("disabled", true).addClass("spin-disabled");
  }
});
